/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.natives.loot.modifier;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.loot.LootManager;
import com.blamejared.crafttweaker.api.loot.condition.LootConditions;
import com.blamejared.crafttweaker.api.loot.modifier.ILootModifier;
import com.blamejared.crafttweaker.natives.loot.condition.ExpandLootItemBlockStatePropertyCondition;
import com.blamejared.crafttweaker.natives.loot.condition.ExpandMatchTool;
import com.blamejared.crafttweaker.natives.predicate.ExpandItemPredicate;
import com.blamejared.crafttweaker.natives.predicate.ExpandMinMaxBoundsInts;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.openzen.zencode.java.ZenCodeType;

@Document(value="vanilla/api/loot/modifier/BlockLootModifiers")
@ZenCodeType.Expansion(value="crafttweaker.api.block.Block")
@ZenRegister
public final class ModifierSpecificExpandBlock {
    @ZenCodeType.Method
    public static void addLootModifier(Block internal, String name, ILootModifier modifier) {
        LootManager.INSTANCE.getModifierManager().register(name, LootConditions.only((LootItemCondition.Builder)ExpandLootItemBlockStatePropertyCondition.create(internal)), modifier);
    }

    @ZenCodeType.Method
    public static void addStateLootModifier(Block internal, String name, StatePropertiesPredicate.Builder statePredicate, ILootModifier modifier) {
        LootManager.INSTANCE.getModifierManager().register(name, LootConditions.only((LootItemCondition.Builder)ExpandLootItemBlockStatePropertyCondition.create(internal).m_81784_(statePredicate)), modifier);
    }

    @ZenCodeType.Method
    public static void addToolLootModifier(Block internal, String name, IItemStack tool, ILootModifier modifier) {
        ModifierSpecificExpandBlock.addToolLootModifier(internal, name, tool, false, modifier);
    }

    @ZenCodeType.Method
    public static void addToolLootModifier(Block internal, String name, IItemStack tool, boolean matchDamage, ILootModifier modifier) {
        ModifierSpecificExpandBlock.addToolLootModifier(internal, name, tool, matchDamage, false, modifier);
    }

    @ZenCodeType.Method
    public static void addToolLootModifier(Block internal, String name, IItemStack tool, boolean matchDamage, boolean matchNbt, ILootModifier modifier) {
        CompoundTag tag;
        ItemPredicate.Builder predicateBuilder = ExpandItemPredicate.create(tool);
        if (matchDamage) {
            predicateBuilder.m_151449_(ExpandMinMaxBoundsInts.exactly(tool.getDamage()));
        }
        if (matchNbt && (tag = tool.getInternal().m_41783_()) != null) {
            predicateBuilder.m_45075_(tag);
        }
        LootManager.INSTANCE.getModifierManager().register(name, LootConditions.allOf(new LootItemCondition.Builder[]{ExpandLootItemBlockStatePropertyCondition.create(internal), ExpandMatchTool.create(predicateBuilder)}), modifier);
    }
}

